# SPDX-License-Identifier: Apache-2.0
# Copyright 2019 The Meson development team

from __future__ import annotations

import argparse
import subprocess
from pathlib import Path

from .run_tool import run_tool
import typing as T

def run_clang_tidy(fname: Path, builddir: Path) -> subprocess.CompletedProcess:
    return subprocess.run(['clang-tidy', '-quiet', '-p', str(builddir), str(fname)])

def run_clang_tidy_fix(fname: Path, builddir: Path) -> subprocess.CompletedProcess:
    return subprocess.run(['run-clang-tidy', '-fix', '-format', '-quiet', '-p', str(builddir), str(fname)])

def run(args: T.List[str]) -> int:
    parser = argparse.ArgumentParser()
    parser.add_argument('--fix', action='store_true')
    parser.add_argument('sourcedir')
    parser.add_argument('builddir')
    options = parser.parse_args(args)

    srcdir = Path(options.sourcedir)
    builddir = Path(options.builddir)

    run_func = run_clang_tidy_fix if options.fix else run_clang_tidy
    return run_tool('clang-tidy', srcdir, builddir, run_func, builddir)
