#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2018 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
# -------------------------------------------------------------------------
#
# influence of the nmax (time step)
# on the L1-error & mass-loss computation
#
ih=${1-"25"} # 1/h
k=${2-"2"}
subdivide=${3-"4"}
field_error=${4-"1e-12"}
loop=true
LN="13 25 49 94 187 375 750 1500 3000 6000 12000 24000 48000 96000"
echo "# generated by `basename $0`"
echo "# h = 1/${ih}"
echo "# k = ${k}"
echo "# subdivide = ${subdivide}"
echo "# field_error = ${field_error}"
echo "# nmax err_linf_l1 v_max size hmin"
for nmax in $LN; do
  branch="zalesak-${ih}-P${k}d-${nmax}.branch.gz"
  (zcat $branch | ./zalesak_dg_adapt ${subdivide} ${field_error} | ./zalesak_dg_error 1 ) 2>/dev/null > tmp.txt
  err_linf_l1=`grep err_linf_l1 tmp.txt | awk '{print $4}'`
  v_max=`grep v_max tmp.txt | awk '{print $4}'`
  size=`grep "omega.size" tmp.txt | awk '{print $4}'`
  hmin=`grep "hmin" tmp.txt | awk '{print $4}'`
  echo "$nmax $err_linf_l1 $v_max $size $hmin"
done
